/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.win32.DEVMODE;
import org.eclipse.swt.internal.win32.DEVMODEA;
import org.eclipse.swt.internal.win32.DEVMODEW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    static final TCHAR DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
    PrinterData printerData = new PrinterData();
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        if ((n & n2) == 0) {
            n |= 0x10000;
        }
        if (((n &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }

    public PrinterData open() {
        int n;
        int n2;
        Shell shell = this.getParent();
        int n3 = this.getStyle();
        int n4 = shell.handle;
        int n5 = shell.handle;
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n2 = n3 & 0x6000000) != (n = shell.getStyle() & 0x6000000)) {
            int n6 = 0x100000;
            if (n2 == 0x4000000) {
                n6 |= 0x400000;
            }
            n4 = OS.CreateWindowEx(n6, DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n5, 0, OS.GetModuleHandle(null), null);
            bl = OS.IsWindowEnabled(n5);
            if (bl) {
                OS.EnableWindow(n5, false);
            }
        }
        PrinterData printerData = null;
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        pRINTDLG.hwndOwner = n4;
        pRINTDLG.Flags = 1024;
        if (OS.PrintDlg(pRINTDLG)) {
            int n7;
            int n8;
            byte[] byArray;
            if (pRINTDLG.hDevNames != 0) {
                OS.GlobalFree(pRINTDLG.hDevNames);
                pRINTDLG.hDevNames = 0;
            }
            if ((byArray = this.printerData.otherData) != null && byArray.length != 0) {
                n8 = OS.GlobalAlloc(64, byArray.length);
                OS.MoveMemory(n8, byArray, byArray.length);
                if (pRINTDLG.hDevMode != 0) {
                    OS.GlobalFree(pRINTDLG.hDevMode);
                }
                pRINTDLG.hDevMode = n8;
            }
            n8 = pRINTDLG.hDevMode;
            int n9 = OS.GlobalLock(n8);
            DEVMODE dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
            OS.MoveMemory(dEVMODE, n9, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            dEVMODE.dmFields |= 1;
            dEVMODE.dmOrientation = (short)(this.printerData.orientation == 1 ? 1 : 2);
            if (this.printerData.copyCount != 1) {
                dEVMODE.dmFields |= 0x100;
                dEVMODE.dmCopies = (short)this.printerData.copyCount;
            }
            if (this.printerData.collate) {
                dEVMODE.dmFields |= 0x8000;
                dEVMODE.dmCollate = 1;
            }
            OS.MoveMemory(n9, dEVMODE, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            OS.GlobalUnlock(n8);
            pRINTDLG.Flags = 262144;
            if (this.printerData.printToFile) {
                pRINTDLG.Flags |= 0x20;
            }
            switch (this.printerData.scope) {
                case 1: {
                    pRINTDLG.Flags |= 2;
                    break;
                }
                case 2: {
                    pRINTDLG.Flags |= 1;
                    break;
                }
                default: {
                    pRINTDLG.Flags |= 0;
                }
            }
            pRINTDLG.nMinPage = 1;
            pRINTDLG.nMaxPage = (short)-1;
            pRINTDLG.nFromPage = (short)Math.min(65535, Math.max(1, this.printerData.startPage));
            pRINTDLG.nToPage = (short)Math.min(65535, Math.max(1, this.printerData.endPage));
            Display display = shell.getDisplay();
            Shell[] shellArray = display.getShells();
            if ((this.getStyle() & 0x30000) != 0) {
                int n10 = 0;
                while (n10 < shellArray.length) {
                    if (shellArray[n10].isEnabled() && shellArray[n10] != shell) {
                        shellArray[n10].setEnabled(false);
                    } else {
                        shellArray[n10] = null;
                    }
                    ++n10;
                }
            }
            String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
            Object object = display.getData(string);
            display.setData(string, new Boolean(true));
            boolean bl2 = OS.PrintDlg(pRINTDLG);
            display.setData(string, object);
            if ((this.getStyle() & 0x30000) != 0) {
                n7 = 0;
                while (n7 < shellArray.length) {
                    if (shellArray[n7] != null && !shellArray[n7].isDisposed()) {
                        shellArray[n7].setEnabled(true);
                    }
                    ++n7;
                }
            }
            if (bl2) {
                n8 = pRINTDLG.hDevNames;
                n7 = OS.GlobalSize(n8) / TCHAR.sizeof * TCHAR.sizeof;
                n9 = OS.GlobalLock(n8);
                short[] sArray = new short[4];
                OS.MoveMemory(sArray, n9, 2 * sArray.length);
                TCHAR tCHAR = new TCHAR(0, n7);
                OS.MoveMemory(tCHAR, n9, n7);
                OS.GlobalUnlock(n8);
                short s = sArray[0];
                int n11 = 0;
                while (s + n11 < n7) {
                    if (tCHAR.tcharAt(s + n11) == 0) break;
                    ++n11;
                }
                String string2 = tCHAR.toString(s, n11);
                short s2 = sArray[1];
                n11 = 0;
                while (s2 + n11 < n7) {
                    if (tCHAR.tcharAt(s2 + n11) == 0) break;
                    ++n11;
                }
                String string3 = tCHAR.toString(s2, n11);
                short s3 = sArray[2];
                n11 = 0;
                while (s3 + n11 < n7) {
                    if (tCHAR.tcharAt(s3 + n11) == 0) break;
                    ++n11;
                }
                String string4 = tCHAR.toString(s3, n11);
                printerData = new PrinterData(string2, string3);
                if ((pRINTDLG.Flags & 2) != 0) {
                    printerData.scope = 1;
                    printerData.startPage = pRINTDLG.nFromPage & 0xFFFF;
                    printerData.endPage = pRINTDLG.nToPage & 0xFFFF;
                } else if ((pRINTDLG.Flags & 1) != 0) {
                    printerData.scope = 2;
                }
                boolean bl3 = printerData.printToFile = (pRINTDLG.Flags & 0x20) != 0;
                if (printerData.printToFile) {
                    printerData.fileName = string4;
                }
                printerData.copyCount = pRINTDLG.nCopies;
                printerData.collate = (pRINTDLG.Flags & 0x10) != 0;
                n8 = pRINTDLG.hDevMode;
                n7 = OS.GlobalSize(n8);
                n9 = OS.GlobalLock(n8);
                printerData.otherData = new byte[n7];
                OS.MoveMemory(printerData.otherData, n9, n7);
                dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
                OS.MoveMemory(dEVMODE, n9, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
                if ((dEVMODE.dmFields & 1) != 0) {
                    short s4 = dEVMODE.dmOrientation;
                    printerData.orientation = s4 == 2 ? 2 : 1;
                }
                OS.GlobalUnlock(n8);
                this.printerData = printerData;
            }
        }
        if (pRINTDLG.hDevNames != 0) {
            OS.GlobalFree(pRINTDLG.hDevNames);
            pRINTDLG.hDevNames = 0;
        }
        if (pRINTDLG.hDevMode != 0) {
            OS.GlobalFree(pRINTDLG.hDevMode);
            pRINTDLG.hDevMode = 0;
        }
        if (n5 != n4) {
            if (bl) {
                OS.EnableWindow(n5, true);
            }
            OS.SetActiveWindow(n5);
            OS.DestroyWindow(n4);
        }
        return printerData;
    }
}

