/*
 * Decompiled with CFR 0.152.
 */
package com.lki.pg;

import com.lki.pg.connMerge;
import com.lki.pg.dialogPage;
import com.lki.pg.genPassword;
import com.lki.pg.listData;
import com.lki.pg.manageDB;
import java.util.ArrayList;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class genPassPage
implements SelectionListener {
    public int m_x = 5;
    public int m_y = 5;
    public Shell m_shell = null;
    public Text m_txtKey;
    public Text m_txtIp;
    public Text m_txtPort;
    public Label m_lbSiteName;
    public Label m_lbId;
    public Label m_lbRegDate;
    public Label m_lbPw;
    public int m_banx = 370;
    public int m_bany = 250;
    public Button m_btnNew;
    public Button m_btnEdit;
    public Button m_btnDel;
    public Button m_btnCopy;
    public Button m_btnMerge;
    public Table m_tbList;

    public genPassPage(Shell shell) {
        this.m_shell = shell;
        this.createKeyValue();
        this.createInfoGroup();
        this.createConnect();
        this.createList();
    }

    public void createKeyValue() {
        Label label = new Label((Composite)this.m_shell, 0);
        label.setBounds(this.m_x, this.m_y, 60, 20);
        label.setText("Key Value : ");
        this.m_txtKey = new Text((Composite)this.m_shell, 2048);
        this.m_txtKey.setBounds(this.m_x + 70, this.m_y, 120, 20);
        this.m_txtKey.setEchoChar('*');
        this.m_y += 25;
    }

    public void createConnect() {
        int gp_x = 10;
        int gp_y = 15;
        int value_x = 50;
        Group infoGroup = new Group((Composite)this.m_shell, 0);
        infoGroup.setText("Connect");
        Label label = new Label((Composite)infoGroup, 0);
        label.setBounds(gp_x, gp_y, 30, 20);
        label.setText("Ip : ");
        this.m_txtIp = new Text((Composite)infoGroup, 2048);
        this.m_txtIp.setBounds(gp_x + value_x, gp_y, 120, 20);
        label = new Label((Composite)infoGroup, 0);
        label.setBounds(gp_x + 120 + value_x, gp_y, 10, 20);
        label.setText(" : ");
        this.m_txtPort = new Text((Composite)infoGroup, 2048);
        this.m_txtPort.setBounds(gp_x + 130 + value_x, gp_y, 60, 20);
        this.m_btnMerge = new Button((Composite)infoGroup, 0);
        this.m_btnMerge.setBounds(this.m_banx - 50, gp_y, 80, 20);
        this.m_btnMerge.setText("Connect");
        this.m_btnMerge.addSelectionListener((SelectionListener)this);
        infoGroup.setBounds(this.m_x, this.m_y, this.m_banx + 40, gp_y += 25);
        this.m_y += gp_y + 5;
    }

    public void createInfoGroup() {
        int gp_x = 10;
        int gp_y = 15;
        int value_x = 65;
        Group infoGroup = new Group((Composite)this.m_shell, 0);
        infoGroup.setText("Information");
        Label label = new Label((Composite)infoGroup, 0);
        label.setBounds(gp_x, gp_y, 60, 20);
        label.setText("SiteName : ");
        this.m_lbSiteName = new Label((Composite)infoGroup, 0);
        this.m_lbSiteName.setBounds(gp_x + value_x, gp_y, 150, 20);
        this.m_lbSiteName.setText("NONE");
        label = new Label((Composite)infoGroup, 0);
        label.setBounds(gp_x, gp_y += 20, 60, 20);
        label.setText("ID : ");
        this.m_lbId = new Label((Composite)infoGroup, 0);
        this.m_lbId.setBounds(gp_x + value_x, gp_y, 150, 20);
        this.m_lbId.setText("NONE");
        label = new Label((Composite)infoGroup, 0);
        label.setBounds(gp_x, gp_y += 20, 60, 20);
        label.setText("Reg_Date : ");
        this.m_lbRegDate = new Label((Composite)infoGroup, 0);
        this.m_lbRegDate.setBounds(gp_x + value_x, gp_y, 150, 20);
        this.m_lbRegDate.setText("NONE");
        label = new Label((Composite)infoGroup, 0);
        label.setBounds(gp_x, gp_y += 20, 60, 20);
        label.setText("Password : ");
        this.m_lbPw = new Label((Composite)infoGroup, 0);
        this.m_lbPw.setBounds(gp_x + value_x, gp_y, 150, 20);
        this.m_lbPw.setText("NONE");
        this.m_btnCopy = new Button((Composite)infoGroup, 0);
        this.m_btnCopy.setBounds(this.m_banx - 30, gp_y, 60, 20);
        this.m_btnCopy.setText("Copy");
        this.m_btnCopy.addSelectionListener((SelectionListener)this);
        infoGroup.setBounds(this.m_x, this.m_y, this.m_banx + 40, gp_y += 25);
        this.m_y += gp_y + 5;
    }

    public void createList() {
        Group gpList = new Group((Composite)this.m_shell, 0);
        gpList.setBounds(this.m_x, this.m_y, this.m_banx + 40, this.m_y + this.m_bany + 35);
        gpList.setText("List");
        this.m_tbList = new Table((Composite)gpList, 67584);
        this.m_tbList.setBounds(10, 15, this.m_banx + 20, this.m_y + this.m_bany - 20);
        this.m_tbList.setHeaderVisible(true);
        this.m_tbList.addSelectionListener((SelectionListener)this);
        TableColumn column = new TableColumn(this.m_tbList, 0);
        column.setText("SiteName");
        column.setWidth(110);
        column = new TableColumn(this.m_tbList, 0);
        column.setText("ID");
        column.setWidth(105);
        column = new TableColumn(this.m_tbList, 0);
        column.setText("RegDate");
        column.setWidth(80);
        column = new TableColumn(this.m_tbList, 0);
        column.setText("Arrange");
        column.setWidth(80);
        int nButtonX = 120;
        this.m_btnNew = new Button((Composite)gpList, 0);
        this.m_btnNew.setBounds(nButtonX, this.m_y + this.m_bany, 50, 30);
        this.m_btnNew.setText("New");
        this.m_btnNew.addSelectionListener((SelectionListener)this);
        this.m_btnEdit = new Button((Composite)gpList, 0);
        this.m_btnEdit.setBounds(nButtonX + 60, this.m_y + this.m_bany, 50, 30);
        this.m_btnEdit.setText("Edit");
        this.m_btnEdit.addSelectionListener((SelectionListener)this);
        this.m_btnDel = new Button((Composite)gpList, 0);
        this.m_btnDel.setBounds(nButtonX + 120, this.m_y + this.m_bany, 50, 30);
        this.m_btnDel.setText("Del");
        this.m_btnDel.addSelectionListener((SelectionListener)this);
        ArrayList<listData> arrList = manageDB.getValues();
        int i = 0;
        while (i < arrList.size()) {
            TableItem item = new TableItem(this.m_tbList, 0);
            item.setText(0, arrList.get((int)i).strSiteName);
            item.setText(1, arrList.get((int)i).strId);
            item.setText(2, arrList.get((int)i).strRegDate);
            item.setText(3, arrList.get((int)i).strArrange);
            ++i;
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Password Generator");
        new genPassPage(shell);
        shell.open();
        shell.pack();
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent arg0) {
            }

            public void shellClosed(ShellEvent arg0) {
                connMerge.m_nCommand = 5;
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellIconified(ShellEvent arg0) {
            }
        });
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (event.getSource() == this.m_btnNew) {
            System.out.printf("New", new Object[0]);
        } else if (event.getSource() == this.m_btnEdit) {
            System.out.printf("Edit", new Object[0]);
        } else if (event.getSource() == this.m_btnDel) {
            System.out.printf("Del", new Object[0]);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.m_btnNew) {
            dialogPage dialog = new dialogPage(this, null);
        } else if (event.getSource() == this.m_btnEdit) {
            if (this.m_tbList.getSelectionIndex() < 0) {
                return;
            }
            TableItem[] item = this.m_tbList.getSelection();
            listData data = new listData(item[0].getText(0), item[0].getText(1), item[0].getText(2), item[0].getText(3));
            dialogPage dialog = new dialogPage(this, data);
        } else if (event.getSource() == this.m_btnDel) {
            if (this.m_tbList.getSelectionIndex() < 0) {
                return;
            }
            String strSite = this.m_tbList.getSelection()[0].getText(0);
            manageDB.deleteData(strSite);
            this.m_tbList.remove(this.m_tbList.getSelectionIndex());
            if (connMerge.m_nCommand != 5) {
                connMerge.m_sItem = new listData(strSite, "temp", "temp", "temp");
                connMerge.m_nCommand = 3;
            }
        } else if (event.getSource() == this.m_btnCopy) {
            Clipboard clip = new Clipboard(this.m_shell.getDisplay());
            clip.setContents(new Object[]{this.m_lbPw.getText()}, new Transfer[]{TextTransfer.getInstance()});
            clip.dispose();
        } else if (event.getSource() == this.m_tbList) {
            TableItem[] item = this.m_tbList.getSelection();
            String strPw = genPassword.getPassword(item[0].getText(0), item[0].getText(1), item[0].getText(2), this.m_txtKey.getText(), item[0].getText(3));
            this.m_lbSiteName.setText(item[0].getText(0));
            this.m_lbId.setText(item[0].getText(1));
            this.m_lbRegDate.setText(item[0].getText(2));
            this.m_lbPw.setText(strPw);
        } else if (event.getSource() == this.m_btnMerge) {
            int port = 0;
            try {
                port = Integer.parseInt(this.m_txtPort.getText());
            }
            catch (Exception e) {
                port = 0;
            }
            if (this.m_btnMerge.getText().equals("Connect")) {
                this.m_btnMerge.setText("Disconnect");
                connMerge.m_nCommand = 1;
                Thread merge = new Thread(new connMerge(this, this.m_txtIp.getText(), port));
                merge.start();
            } else if (this.m_btnMerge.getText().equals("Disconnect")) {
                connMerge.m_nCommand = 5;
            }
        }
    }

    public void refreshTable() {
        this.m_tbList.removeAll();
        ArrayList<listData> arrList = manageDB.getValues();
        int i = 0;
        while (i < arrList.size()) {
            TableItem item = new TableItem(this.m_tbList, 0);
            item.setText(0, arrList.get((int)i).strSiteName);
            item.setText(1, arrList.get((int)i).strId);
            item.setText(2, arrList.get((int)i).strRegDate);
            item.setText(3, arrList.get((int)i).strArrange);
            ++i;
        }
    }
}

