/*
 * Decompiled with CFR 0.152.
 */
package com.lki.pg;

import com.lki.pg.listData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class manageDB {
    private static final String DATABASE_NAME = "memberdb";
    private static String TABLE_NAME = "member";
    private static manageDB inst;
    private Connection conn = null;
    private PreparedStatement prestatement = null;
    private Statement statement = null;
    private ResultSet rs = null;

    public Connection connection(String dbFileName) throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        String url = "jdbc:sqlite:/" + dbFileName;
        Connection conn = DriverManager.getConnection(url);
        return conn;
    }

    public static void init() {
        if (inst == null) {
            inst = new manageDB();
        }
        try {
            manageDB.inst.conn = inst.connection(String.valueOf(System.getProperty("user.dir")) + "/" + DATABASE_NAME + ".db");
            manageDB.inst.statement = manageDB.inst.conn.createStatement();
            manageDB.inst.statement.executeUpdate("create table if not exists " + TABLE_NAME + " (" + "no integer primary key autoincrement, " + "sitename text unique not null, " + "id text not null, " + "date text not null, " + "arrange text not null);");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean setValues(listData list) {
        return manageDB.setValues(list.strSiteName, list.strId, list.strRegDate, list.strArrange);
    }

    public static boolean setValues(String siteName, String id, String regDate, String arrange) {
        boolean result = true;
        manageDB.init();
        try {
            try {
                PreparedStatement prep = manageDB.inst.conn.prepareStatement("insert into " + TABLE_NAME + " (sitename, id, date, arrange) values(?, ?, ?, ?);");
                prep.setString(1, siteName);
                prep.setString(2, id);
                prep.setString(3, regDate);
                prep.setString(4, arrange.toUpperCase());
                prep.addBatch();
                prep.executeBatch();
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                try {
                    if (manageDB.inst.conn != null) {
                        manageDB.inst.conn.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    result = false;
                }
            }
        }
        finally {
            try {
                if (manageDB.inst.conn != null) {
                    manageDB.inst.conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public static boolean deleteData(String siteName) {
        boolean result = true;
        manageDB.init();
        try {
            try {
                manageDB.inst.statement.executeUpdate("delete from " + TABLE_NAME + " where sitename == \"" + siteName + "\";");
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                try {
                    if (manageDB.inst.conn != null) {
                        manageDB.inst.conn.close();
                    }
                    if (manageDB.inst.statement != null) {
                        manageDB.inst.statement.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    result = false;
                }
            }
        }
        finally {
            try {
                if (manageDB.inst.conn != null) {
                    manageDB.inst.conn.close();
                }
                if (manageDB.inst.statement != null) {
                    manageDB.inst.statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public static ArrayList<listData> getValues() {
        manageDB.init();
        ArrayList<listData> arData = new ArrayList<listData>();
        try {
            try {
                manageDB.inst.prestatement = manageDB.inst.conn.prepareStatement("select * from " + TABLE_NAME + " order by sitename asc;");
                manageDB.inst.rs = manageDB.inst.prestatement.executeQuery();
                while (manageDB.inst.rs.next()) {
                    arData.add(new listData(manageDB.inst.rs.getString("sitename"), manageDB.inst.rs.getString("id"), manageDB.inst.rs.getString("date"), manageDB.inst.rs.getString("arrange")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (manageDB.inst.rs != null) {
                        manageDB.inst.rs.close();
                    }
                    if (manageDB.inst.prestatement != null) {
                        manageDB.inst.prestatement.close();
                    }
                    if (manageDB.inst.conn != null) {
                        manageDB.inst.conn.close();
                    }
                    if (manageDB.inst.statement != null) {
                        manageDB.inst.statement.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (manageDB.inst.rs != null) {
                    manageDB.inst.rs.close();
                }
                if (manageDB.inst.prestatement != null) {
                    manageDB.inst.prestatement.close();
                }
                if (manageDB.inst.conn != null) {
                    manageDB.inst.conn.close();
                }
                if (manageDB.inst.statement != null) {
                    manageDB.inst.statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return arData;
    }

    public static boolean updateData(String pre_siteName, String siteName, String id, String regDate, String arrange) {
        boolean result = true;
        manageDB.init();
        try {
            try {
                manageDB.inst.statement.executeUpdate("update " + TABLE_NAME + " set sitename = \"" + siteName + "\", " + " id = \"" + id + "\", " + " date = \"" + regDate + "\", " + " arrange = \"" + arrange.toUpperCase() + "\" " + " where sitename == \"" + pre_siteName + "\";");
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                try {
                    if (manageDB.inst.conn != null) {
                        manageDB.inst.conn.close();
                    }
                    if (manageDB.inst.statement != null) {
                        manageDB.inst.statement.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    result = false;
                }
            }
        }
        finally {
            try {
                if (manageDB.inst.conn != null) {
                    manageDB.inst.conn.close();
                }
                if (manageDB.inst.statement != null) {
                    manageDB.inst.statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        ArrayList<listData> arr = manageDB.getValues();
        int i = 0;
        while (i < arr.size()) {
            System.out.println("sitename = " + arr.get((int)i).strSiteName);
            System.out.println("id = " + arr.get((int)i).strId);
            System.out.println("date = " + arr.get((int)i).strRegDate);
            System.out.println("date = " + arr.get((int)i).strArrange);
            ++i;
        }
    }
}

